* Figure 8.do;
*version 17
#d ;
clear;
cap log close;
set more off;
set type double;
set scheme s1color;
set linesize 100;
pause on;

local xyear=2019;

cap log close;
log using "${log}07 Figure 8.log", replace;
use "${CE}/ce_cpc_comb_haall_v7.dta", clear;
count;

* after tax with SNAP;
gen c_rinc_aftertax=c_rfinc_addfsm-c_rtaxm2;
gen c_poor_rinc_aftertax=c_rinc_aftertax<c_rspm_thres if c_rspm_thres<.;



***************;
* to match CE we should exclude 7 states FIPS 19,35,38,50,56,44,40 where there is no CE data.
* unfortunately our original CPSP data does not include State.  So the samples states differ.;

*************************
* time series graphs;
************************;
keep if year>=2004 & c_house_grp>0;

* means for children, c_princk_xfhlwc is without snap and other inkind aid;
* define poverty rates with and without transfers;
* resources without transfers.  transfers have no missings;
gen c_chldpres= c_nchild>0 & c_nchild<.;

gen c_rinck_xf=c_rinck - c_rsnap;
gen c_rinck_xfh = c_rinck_xf-c_rhousesub;
gen c_rinck_xfhl = c_rinck_xfh-c_rschlunch;
gen c_rinck_xfhlw = c_rinck_xfhl-c_rwic;
gen c_rinck_xfhlwe = c_rinck_xfhlw-c_rliheap;
gen c_rinck_xfhlwee = c_rinck_xfhlwe-c_reitc;
gen c_rinck_xfhlweei = c_rinck_xfhlwee-c_rssi;
gen c_rinck_xfhlweeia = c_rinck_xfhlweei-c_rwelf;

gen c_rinck_xs = c_rinck -c_rsocsec;
gen c_rinck_xse = c_rinck -c_rsocsec-c_reitc;
gen c_rinck_xsei = c_rinck -c_rsocsec -c_rssi-c_reitc;
gen c_rinck_xseia = c_rinck -c_rsocsec -c_rssi -c_rwelf-c_reitc;  // a for afdc;
gen c_rinck_xfseia =c_rinck_xf -c_rsocsec -c_rssi -c_rwelf-c_reitc;
gen c_rinck_xkseia =c_rinck_xfhlwe -c_rsocsec -c_rssi -c_rwelf-c_reitc;

gen c_rinck_x = c_rinck ;
gen c_rinck_xe = c_rinck -c_reitc;
gen c_rinck_xei = c_rinck  -c_rssi-c_reitc;
gen c_rinck_xeia = c_rinck  -c_rssi -c_rwelf-c_reitc;  // a for afdc;
gen c_rinck_xfeia =c_rinck_xf  -c_rssi -c_rwelf-c_reitc;
gen c_rinck_xkeia =c_rinck_xfhlwe  -c_rssi -c_rwelf-c_reitc;

local plist "xf xfh xfhl xfhlw xfhlwe xfhlwee xfhlweei xfhlweeia xs xse xsei xseia xfseia xkseia xe xei xeia xfeia xkeia";

foreach z in `plist' {;
	gen c_princk_`z' = c_rinck_`z' < c_rspm_thres;
};

************************************;
gen c_rexpk_xf=c_rexpk - c_rsnap;
gen c_rexpk_xfh = c_rexpk_xf-c_rhousesub;
gen c_rexpk_xfhl = c_rexpk_xfh-c_rschlunch;
gen c_rexpk_xfhlw = c_rexpk_xfhl-c_rwic;
gen c_rexpk_xfhlwe = c_rexpk_xfhlw-c_rliheap;
gen c_rexpk_xfhlwee = c_rexpk_xfhlwe-c_reitc;
gen c_rexpk_xfhlweei = c_rexpk_xfhlwee-c_rssi;
gen c_rexpk_xfhlweeia = c_rexpk_xfhlweei-c_rwelf;

gen c_rexpk_xs = c_rexpk -c_rsocsec;
gen c_rexpk_xse = c_rexpk -c_rsocsec -c_reitc;
gen c_rexpk_xsei = c_rexpk -c_rsocsec -c_rssi-c_reitc;
gen c_rexpk_xseia = c_rexpk -c_rsocsec -c_rssi -c_rwelf-c_reitc;  // a for afdc;
gen c_rexpk_xfseia =c_rexpk_xf -c_rsocsec -c_rssi -c_rwelf-c_reitc;
gen c_rexpk_xkseia =c_rexpk_xfhlwe -c_rsocsec -c_rssi -c_rwelf-c_reitc;

gen c_rexpk_x = c_rexpk ;
gen c_rexpk_xe = c_rexpk  -c_reitc;
gen c_rexpk_xei = c_rexpk  -c_rssi-c_reitc;
gen c_rexpk_xeia = c_rexpk -c_rssi -c_rwelf-c_reitc;  // a for afdc;
gen c_rexpk_xfeia =c_rexpk_xf  -c_rssi -c_rwelf-c_reitc;
gen c_rexpk_xkeia =c_rexpk_xfhlwe  -c_rssi -c_rwelf-c_reitc;

local plist "xf xfh xfhl xfhlw xfhlwe xfhlwee xfhlweei xfhlweeia xs xse xsei xseia xfseia xkseia xe xei xeia xfeia xkeia";

foreach z in `plist' {;
	gen c_prexpk_`z' = c_rexpk_`z' < c_rspm_thres;
};

local tranlistinc0 "c_poor_rinck c_princk_xf c_princk_xfh c_princk_xfhl c_princk_xfhlw c_princk_xfhlwe c_princk_xfhlwee c_princk_xfhlweei c_princk_xfhlweeia";
local tranlistexp0 "c_poor_rexpk c_prexpk_xf c_prexpk_xfh c_prexpk_xfhl c_prexpk_xfhlw c_prexpk_xfhlwe c_prexpk_xfhlwee c_prexpk_xfhlweei c_prexpk_xfhlweeia";

local tranlistinc " c_poor_rinck c_princk_xs c_princk_xse c_princk_xsei c_princk_xseia c_princk_xfseia c_princk_xkseia";
local tranlistexp "c_poor_rexpk c_prexpk_xs c_prexpk_xse c_prexpk_xsei c_prexpk_xseia c_prexpk_xfseia c_prexpk_xkseia";

label var c_poor_rinck "SIPM";
label var c_princk_xf "w/o snap";
label var c_princk_xfh "w/o snap, housesub";
label var c_princk_xfhl "w/o snap, housesub, sch. lunch";
label var c_princk_xfhlw "w/o snap, housesub, sch. lunch, wic";
label var c_princk_xfhlwe "w/o snap, housesub, sch. lunch, wic,liheap";
label var c_princk_xfhlwee "w/o in-kind, eitc";
label var c_princk_xfhlweei "w/o in-kind, eitc, ssi";
label var c_princk_xfhlweeia "w/o in-kind, eitc, ssi, cash welfare";

label var c_princk_xe " w/o eitc";
label var c_princk_xei "w/o  eitc ssi";
label var c_princk_xeia "w/o eitc ssi welfare";
label var c_princk_xfeia "w/o eitc ssi welfare SNAP";
label var c_princk_xkeia "w/o eitc ssi welfare SNAP inkind";

local tranlistinc2 " c_poor_rinck c_princk_xe c_princk_xei c_princk_xeia c_princk_xfeia c_princk_xkeia";

label var c_poor_rexpk "SEPM";
label var c_prexpk_xf "w/o snap";
label var c_prexpk_xfh "w/o snap, housesub";
label var c_prexpk_xfhl "w/o snap, housesub, sch. lunch";
label var c_prexpk_xfhlw "w/o snap, housesub, sch. lunch, wic";
label var c_prexpk_xfhlwe "w/o snap, housesub, sch. lunch, wic,liheap";
label var c_prexpk_xfhlwee "w/o in-kind, eitc";
label var c_prexpk_xfhlweei "w/o in-kind, eitc, ssi";
label var c_prexpk_xfhlweeia "w/o in-kind, eitc, ssi, cash welfare";

label var c_poor_rexpk "SEPM";
label var c_prexpk_xe "w/o, eitc";
label var c_prexpk_xei "w/o, eitc ssi";
label var c_prexpk_xeia "w/o, eitc ssi welfare";
label var c_prexpk_xfeia "w/o, eitc ssi welfare SNAP";
label var c_prexpk_xkeia "w/o, eitc ssi welfare SNAP inkind";

local tranlistexp2 "c_poor_rexpk c_prexpk_xe c_prexpk_xei c_prexpk_xeia c_prexpk_xfeia c_prexpk_xkeia";

preserve;
*full sample;
collapse c_poor_rexpk c_poor_rinck c_princk_x* c_prexpk_x* [aweight=c_perpopwt], by(asecsurvey year );

for var c_poor_rexpk c_prexpk_xfhlwe c_prexpk_xkeia c_poor_rinck c_princk_xfhlwe c_princk_xkeia : replace X = X * 100 ; 

* subract transfers;
twoway (line c_poor_rexpk year if asecsurvey==0 ,color(red)) 
(line c_poor_rinck year if asecsurvey==1 , color(blue)) 
(line c_prexpk_xfhlwe year if asecsurvey==0 ,color(red%50) lp(dash)) 
(line c_princk_xfhlwe year if asecsurvey==1 ,lp(dash) color(blue%50))
(line c_prexpk_xkeia year if asecsurvey==0 ,color(red) lp(shortdash_dot)) 
(line c_princk_xkeia year if asecsurvey==1 ,lp(shortdash_dot) color(blue)),
title("Figure 8: Impact of Selected Transfers on Poverty All Persons, 2004–2019" " ", size(11pt)) 
ytitle("Poverty Rate (%)" "") ylabel(5(5)25,format(%3.0fc) labsize(small) angle(0)) 
xtitle("") xlabel(,labsize(small)) 
legend(size(small) label(1 "CE SEPM") label(3 "CE SEPM w/o SPM Transfers") 
label(5 "CE SEPM w/o Broad Transfers")
label(2 "ASEC SIPM") label(4 "ASEC SIPM w/o SPM Transfers")
label(6 "ASEC SIPM w/o Broad Transfers")) 
note("SIPM measures use taxsim, geographic cost of living adjustment, and 15 grp imputation. SPM transfers are SNAP, WIC, housing assistance," "energy assistance, and school lunch. Broad transfers are SPM transfers plus the ETIC, cash welfare, and SSI.", size(vsmall) span) 
saving("${outgraph}07 Impact of Transfers (Figure 8 C).gph", replace);
graph export "${outgraph}07 Impact of Transfers (Figure 8 C).pdf",replace;

twoway (line c_poor_rexpk year if asecsurvey==0 ,color(gray)) 
(line c_poor_rinck year if asecsurvey==1 , color(gray%50)) ///2
(line c_prexpk_xfhlwe year if asecsurvey==0 ,color(gray) lp(dash)) ///3
(line c_princk_xfhlwe year if asecsurvey==1 ,lp(dash) color(gray%50)) ///4
(line c_prexpk_xkeia year if asecsurvey==0 ,color(gray) lp(shortdash_dot)) ///5
(line c_princk_xkeia year if asecsurvey==1 ,lp(shortdash_dot) color(gray%50)), ///6
title("Figure 8: Impact of Selected Transfers on Poverty All Persons, 2004–2019" " ", size(11pt)) 
ytitle("Poverty Rate (%)" "") ylabel(5(5)25,format(%3.0fc) labsize(small) angle(0)) 
xtitle("") xlabel(,labsize(small)) 
legend(size(small) label(1 "CE SEPM") label(3 "CE SEPM w/o SPM Transfers") 
label(5 "CE SEPM w/o Broad Transfers")
label(2 "ASEC SIPM") label(4 "ASEC SIPM w/o SPM Transfers")
label(6 "ASEC SIPM w/o Broad Transfers")) 
note("SIPM measures use taxsim, geographic cost of living adjustment, and 15 grp imputation. SPM transfers are SNAP, WIC, housing assistance," "energy assistance, and school lunch. Broad transfers are SPM transfers plus the ETIC, cash welfare, and SSI.", size(vsmall) span) 
saving("${outgraph}07 Impact of Transfers (Figure 8 BW).gph", replace);
graph export "${outgraph}07 Impact of Transfers (Figure 8 BW).pdf",replace;


log close; 
